package jp.mosp.common.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.part.KintaiCompilePart;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.VariousPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.payroll.dao.MKintaiDao;
import jp.mosp.payroll.dao.MKintaiKinmuDao;
import jp.mosp.payroll.dto.CompileAmendmentDto;
import jp.mosp.payroll.dto.MKintaiDto;

public abstract class KintaiCompileAction extends AttendanceTotalAction {

	// tB[h
	private MKintaiDao	kintaiDao;
	private MKintaiKinmuDao kinmuDao;

	/**
	 * 
	 * @throws Exception
	 */
	private void prepareMkintaiDao() throws Exception {
		// DAO
		if (VariousPart.chkExistObject(kintaiDao)) {
			return;
		}
		kintaiDao = PartManager.kintaicompile(partInfo()).getMKintaiDao();
	}

	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	protected MKintaiDao kintaiDao() throws Exception {
		prepareMkintaiDao();
		return kintaiDao;
	}

	/**
	 * 
	 * @throws Exception
	 */
	private void prepareMkintaiKinmuDao() throws Exception {
		// DAO
		if (VariousPart.chkExistObject(kinmuDao)) {
			return;
		}
		kinmuDao = PartManager.kintaicompile(partInfo()).getMKintaiKinmuDao();
	}

	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	protected MKintaiKinmuDao kinmuDao() throws Exception {
		prepareMkintaiKinmuDao();
		return kinmuDao;
	}

	/**
	 * FL
	 * @param dto 			ΏDTO
	 * @param targetMonth 	IN
	 * @return truecFAfalsecFL
	 * @throws Exception
	 */
	protected boolean checkApproval(CompileAmendmentDto dto, Date targetMonth) throws Exception {
		// oΕ̎擾Ə
		getAttendanceList(dto.getKCode(), targetMonth);
		// FEF쐬
		int[] number = KintaiCompilePart.makeApprovalNumber(attendanceList);
		// F
		if (number[1] == 0 && number[2] > 0) {
			return true;
		}
		return false;
	}

	/**
	 * ΑӌWv
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @return	mKintaiDto	WvςDTO
	 * @throws Exception
	 */
	protected MKintaiDto getCompiledInfo(
			String kCode,
			Date targetMonth,
			List<MSyukkinboDto> attendanceList
	) throws Exception {
		return PartManager.kintaicompile(partInfo()).getCompiledInfo(
				kCode,
				targetMonth,
				attendanceList
		);
	}

}
